'*************************************************
'*   Finger_Joints V2.0                          *
'*   Variable Geometry Finger Joints             *	
'*   For CamBam Plus                             *
'*   (c) EddyCurrent 2015                        *
'*                                               *
'* Parts based upon code by Lloydsp              *
'*                                               *
'*************************************************

'TODO
'5. Update Manual
'6. Test insatalling over previous installatoin
'****************************EVENT HANDLER *****************************
    Dim CBWindow as System.Windows.Forms.Form = nothing
    Dim ScriptWindow as System.Windows.Forms.Form = nothing
    Dim Form1 As New System.Windows.Forms.form
	
	Dim click_sensed As integer = 0         ' trigger value for any click
	Dim cancel_click_sensed As integer = 0  ' trigger for the Cancel button
	Dim Combo1 As integer = 0				' trigger for the Combo box
	
Sub MASTER_CLOSING(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs)
	'MsgBox("CamBam is closing")
	Form1.close()
	ScriptWindow.close()
	system.diagnostics.process.getcurrentprocess.kill( )
End Sub

Sub OK_CLICKED(ByVal sender As Object, ByVal e As EventArgs)
	'app.log("Got an OK click.")
	click_sensed = 1
	'assign all values to variables ready for drawing etc.
End Sub

Sub CANCEL_CLICKED(ByVal sender As Object, ByVal e As EventArgs)
	' app.log("Got a Cancel click.")
	click_sensed = 1
	cancel_click_sensed = 1
End Sub

Sub MASKWIDTH_CHANGED(ByVal sender As Object, ByVal e As EventArgs)
	'app.log("Mask Width Changed")
	UpdateVisibility()
	UpdateSomeValues2() 
'	Animate()
End Sub

Sub COMBO_CHANGED(ByVal sender As Object, ByVal e As System.EventArgs) 
	'app.log("combo changed")
    Combo1 = 1
	Presets()
End Sub

Sub Value_Changed1(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs)
	'app.log("Value Changed 1")
	UpdateSomeValues2() 
End Sub

Sub Value_Changed2(ByVal sender As Object, ByVal e As EventArgs)
	'app.log("Value Changed 2")
	If Combo1 = 0 then PresetList.SelectedIndex = -1	
	UpdateSomeValues2() 
End Sub

Sub Value_Changed3(ByVal sender As Object, ByVal e As EventArgs)
	'app.log("Value Changed 3")
	If radio1.Checked then HideMaskControls(0)
	If radio2.Checked then HideMaskControls(1)
	UpdateSomeValues2() 
End Sub

Sub Value_Changed4(ByVal sender As Object, ByVal e As EventArgs)
	'app.log("Value Changed 4")
	Animate()
End Sub

'---------------- Global Variables --------------------	
	' declare form controls
	Dim OK_button As New System.Windows.Forms.button
    Dim Cancel_button As New System.Windows.Forms.button
    Dim StockWidthBox As New System.Windows.Forms.Textbox()
    Dim StockThicknessBox As New System.Windows.Forms.Textbox() ' Dim NumFingersBox As New System.Windows.Forms.Textbox()
    Dim NumFingersBox As New System.Windows.Forms.NumericUpDown()
	Dim FitIntBox As New System.Windows.Forms.Textbox() 
    Dim CleanUpBox As New System.Windows.Forms.Textbox()
    Dim ToolDiameterBox As New System.Windows.Forms.Textbox()
	Dim groupBox1 As New System.Windows.Forms.GroupBox()
	Dim radio1 As New System.Windows.Forms.RadioButton()
	Dim radio2 As New System.Windows.Forms.RadioButton()
	Dim Scaling As New System.Windows.Forms.NumericUpDown()
	Dim IsReverse As New System.Windows.Forms.CheckBox()
	Dim SwapStock As New System.Windows.Forms.CheckBox()
	Dim MaskNum As New System.Windows.Forms.NumericUpDown()
	Dim MaskNumLabel As New System.Windows.Forms.Label()
	Dim PresetsLabel As New System.Windows.Forms.Label()
	Dim Mask1 As New System.Windows.Forms.NumericUpDown()
	Dim Mask2 As New System.Windows.Forms.NumericUpDown()
	Dim Mask3 As New System.Windows.Forms.NumericUpDown()
	Dim Mask4 As New System.Windows.Forms.NumericUpDown()
	Dim Mask5 As New System.Windows.Forms.NumericUpDown()
	Dim Mask6 As New System.Windows.Forms.NumericUpDown()
	Dim Mask7 As New System.Windows.Forms.NumericUpDown()
	Dim Mask8 As New System.Windows.Forms.NumericUpDown()
	Dim Mask9 As New System.Windows.Forms.NumericUpDown()
	Dim Mask10 As New System.Windows.Forms.NumericUpDown()
	Dim MaskArray() As System.Windows.Forms.NumericUpDown = {MaskNum,Scaling,Mask1,Mask2,Mask3,Mask4,Mask5,Mask6,Mask7,Mask8,Mask9,Mask10}
	Dim PresetList as new System.Windows.Forms.ComboBox()
	Dim PreS(12) as double	 
	' declare variables for path to pictures
	Dim config As CamBam.CamBamConfig = CamBamConfig.Defaults
	Dim path1 As String =  FileUtils.GetFullPath(config.SystemPath) 

	' declare variables for user inputs
	Dim FJ_StockWidth As double = 1 :	' width of work piece stock
	Dim FJ_StockThickness As double = 1	' thickness of work piece stock
	Dim FJ_NumFingers As double = 20	' number of fingers required
	Dim FJ_ToolDiameter As double = 1 	' diameter of tool
	Dim FJ_Cleanup As double = 0 		' allowance for cleaning up outside ends of joint after assembly
	Dim FJ_FitInt As double = 0 		' Tolerance allowed for 'slackness' of joint
	Dim MaxToolDia As double = 1
	Dim FJ_ScalingNum as double = 1
	Dim FJ_MaskNum as integer = 2
	Dim Mask1Num as double
	Dim Mask2Num as double
	Dim Mask3Num as double
	Dim Mask4Num as double
	Dim Mask5Num as double
	Dim Mask6Num as double
	Dim Mask7Num as double
	Dim Mask8Num as double
	Dim Mask9Num as double
	Dim Mask10Num as double
	
	' declare I/O array
	Dim MaxArraySize As integer = 101 ' size for I/O interface array
	Dim FJ_Points(MaxArraySize) as double 
	
    'declarations for animations
	Dim Anim1 As New System.Windows.Forms.PictureBox()
	Dim F1 As New System.Windows.Forms.Label()	
	Dim F2 As New System.Windows.Forms.Label()
	Dim F3 As New System.Windows.Forms.Label()
	Dim F4 As New System.Windows.Forms.Label()
	Dim F5 As New System.Windows.Forms.Label()
	Dim F6 As New System.Windows.Forms.Label()
	Dim F7 As New System.Windows.Forms.Label()
	Dim F8 As New System.Windows.Forms.Label()
	Dim F9 As New System.Windows.Forms.Label()
	Dim F10 As New System.Windows.Forms.Label()
	Dim F11 As New System.Windows.Forms.Label()
	Dim F12 As New System.Windows.Forms.Label()
	Dim F13 As New System.Windows.Forms.Label()
	Dim F14 As New System.Windows.Forms.Label()
	Dim F15 As New System.Windows.Forms.Label()
	Dim AnimLabels() As System.Windows.Forms.label = {F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,F11,F12,F13,F14,F15}
	
'************************ MAIN ****************************
Sub main
'----------- Code section to Hide the script window --------
    ScriptWindow = System.Windows.Forms.Form.ActiveForm ' identify the scripting window
	CBWindow = CamBam.ThisApplication.TopWindow 		' identify also the CB main window
    CBWindow.BringtoFront()      						' bring the CBwindow to #1 in the Windows z-order
	CBWindow.AddOwnedForm(ScriptWindow) 				' Make CB own the scripting form
	ScriptWindow.hide()
		
	PopulateTheForm()	' init the form	
	HideMaskControls(0) ' default to mask controls hidden
	Form1.Show()  		' display the form	
		
   ' Create the event handlers for the OK and Cancel buttons and some text boxes
	' events enabled only after the form is finished.
	Addhandler OK_button.click, AddressOf OK_CLICKED
	Addhandler Cancel_button.click, AddressOf CANCEL_CLICKED
	AddHandler CBWindow.Closing, AddressOf MASTER_CLOSING
	AddHandler MaskNum.ValueChanged, AddressOf MASKWIDTH_CHANGED
	AddHandler PresetList.SelectedIndexChanged, AddressOf COMBO_CHANGED
	Addhandler ToolDiameterBox.KeyPress, AddressOf Value_Changed1 
	Addhandler NumFingersBox.ValueChanged, AddressOf Value_Changed2 
	Addhandler StockWidthBox.TextChanged, AddressOf Value_Changed2 
	AddHandler Scaling.ValueChanged, AddressOf Value_Changed2	
	Addhandler FitIntBox.TextChanged, AddressOf Value_Changed2 
	AddHandler Mask1.ValueChanged, AddressOf Value_Changed2	
	AddHandler Mask2.ValueChanged, AddressOf Value_Changed2	
	AddHandler Mask3.ValueChanged, AddressOf Value_Changed2	
	AddHandler Mask4.ValueChanged, AddressOf Value_Changed2	
	AddHandler Mask5.ValueChanged, AddressOf Value_Changed2	
	AddHandler Mask6.ValueChanged, AddressOf Value_Changed2	
	AddHandler Mask7.ValueChanged, AddressOf Value_Changed2	
	AddHandler Mask8.ValueChanged, AddressOf Value_Changed2	
	AddHandler Mask9.ValueChanged, AddressOf Value_Changed2	
	AddHandler Mask10.ValueChanged, AddressOf Value_Changed2	
	AddHandler Radio1.CheckedChanged, AddressOf Value_Changed3
	AddHandler IsReverse.CheckedChanged, AddressOf Value_Changed2
	AddHandler SwapStock.CheckedChanged, AddressOf Value_Changed4
	
	' make CamBam own the input form, so it will close with CamBam
	CBWindow.AddOwnedForm(Form1)
	
	F1.Width = MaskNum.Value * 20
	UpdateSomeValues2()
		
	' OK, the form is up on the screen.  Now wait for an event.
    do while click_sensed = 0  ' sit here until either OK or Cancel is clicked
        app.sleep(1) ' add a loop delay so as not to hog all system resources
   	loop
	
    if cancel_click_sensed = 1  ' if it's Cancel, just leave
        goto end_all
    End if
		
'*************************************************
   ' This is the application sub that does the work
    application_Sub()

   '*************************************************
    end_all:
		Form1.close()
		ScriptWindow.show()	 ' re-display the script window
		ScriptWindow.close() ' optionally, close it when done
End Sub

'******************************************************	
	
Sub application_Sub
	
	Dim StockItem1Layer As string = "StockItem1"
	Dim StockItem2Layer As string = "StockItem2"
	Dim CommentsLayer As string = "Comments"
	Dim Comment(12) As String
	Dim RadioText(2) As String
	Dim LowerLeft As Point3F
    Dim FJ_TextPoint As Point3F
	Dim Index As integer
	Dim Fingers As integer
	Dim temp as string
	Dim MaxComments = 9 ' default to not printing mask values
	Dim maskcomment() as string = { Mask3.Value,Mask4.Value,Mask5.Value,Mask6.Value, _
	                                Mask7.Value,Mask8.Value,Mask9.Value,Mask10.Value}
	' texts for comments layer
	RadioText(1) = radio1.Text
	RadioText(2) = radio2.Text
	Comment(0) = "Stock Width = " & FJ_StockWidth
	Comment(1) = "Stock Thickness = " & FJ_StockThickness
	Comment(2) = "Number of Fingers = " & FJ_NumFingers
	Comment(3) = "Fit Interference = " & FJ_FitInt
	Comment(4) = "Cleanup Allowance = " & FJ_Cleanup
    Comment(5) = "Tool Diameter = " & FJ_ToolDiameter
	Comment(6) = "Reversed = " & IsReverse.Checked
	Comment(7) = "Scaling = " & FJ_ScalingNum
	Comment(8) = "Swap Stock = " & SwapStock.Checked
	Comment(9) = "Pattern = " & RadioText(RadioButtonID)
	Comment(10) = "Pattern Width = " & FJ_MaskNum
    Comment(11) = "Pattern = " & Mask1.Value & " , " & Mask2.Value
    
	' populate string with correct number of mask values
	for Index = 0  to FJ_MaskNum-3
		Comment(11) = (Comment(11) & " , " & maskcomment(Index))
	next Index
		
	' create layers for MOPs	
	CreateLayer(StockItem1Layer, "Cyan")
	CreateLayer(StockItem2Layer, "Magenta")
	CreateLayer(CommentsLayer, "Yellow")
	
    ' choose maths routine based upon radio button selection
	Select Case RadioButtonID				
		Case 1 ' Graduated 
			RunMaths2()		
		Case 2 ' Pattern
		    RunMaths3()
		End Select
	
	if SwapStock.Checked then
		temp = StockItem1Layer
	    StockItem1Layer = StockItem2Layer
		StockItem2Layer = temp
	end if	
	
	'fill the I/O array
	Index=1
	for Fingers = 0 to FJ_NumFingers-1
		LowerLeft.x = LowerLeft.x + FJ_Points(Fingers) 
		if Index >0 then 
			DrawRectangle(LowerLeft, FJ_Points(Fingers+1), FJ_StockThickness, StockItem1Layer, 0.6 * FJ_ToolDiameter)
		else
			DrawRectangle(LowerLeft, FJ_Points(Fingers+1), FJ_StockThickness, StockItem2Layer, 0.6 * FJ_ToolDiameter)
		End if
		Index = Index * -1
	next Fingers	

	' set position for first line of text
    FJ_TextPoint.x = -90
	FJ_TextPoint.y = 70

	' only print patterns if they were selected 
	if RadioButtonID = 2 then MaxComments = 11
	
	' write out the text
	for Index = 0 to MaxComments
		WriteText(FJ_TextPoint, CommentsLayer, Comment(Index))
		FJ_TextPoint.y = FJ_TextPoint.y - 7
	next Index 

	WriteMachiningOptions()			' write Machining section
	WritePocketMOP(StockItem1Layer)	' write MOP section for layer 1
	WritePocketMOP(StockItem2Layer)	' write MOP section for layer 2

	update()
End Sub

'******************************************************

Sub WriteMachiningOptions()
	Dim S1 As Point3F
	
	S1.x = FJ_StockWidth
	S1.y = FJ_StockThickness
	S1.z = 120
		
	doc.MachiningOptions.Stock.StockSize = S1
	' set this to your prefered Post Processor
	'doc.MachiningOptions.PostProcessor = "Mach3-CutViewer"
End Sub

'******************************************************
	
Sub CreateLayer(LayerName As String, ColourName As String)
	Dim L1 As Layer
	
	L1 = doc.CreateLayer(LayerName)
	L1.Color = Color.FromName(ColourName)
End Sub

'******************************************************

Sub WritePocketMOP(LayerID As String)
   	Dim Pocket = new CamBam.CAM.MOPPocket(doc, doc.Layers(LayerID).Entities.ToArray())
	Dim MOPParameter
	
	MOPParameter = Pocket.ToolDiameter
	MOPParameter.SetValue(FJ_ToolDiameter)
	Pocket.ToolDiameter = MOPParameter
	
	MOPParameter = Pocket.DepthIncrement
	MOPParameter.SetValue(FJ_ToolDiameter/2)
	Pocket.DepthIncrement = MOPParameter
	
	MOPParameter = Pocket.TargetDepth
	MOPParameter.SetValue((FJ_StockThickness + FJ_Cleanup) * -1)
	Pocket.TargetDepth = MOPParameter
	
	MOPParameter = Pocket.RoughingClearance
	MOPParameter.SetValue(FJ_FitInt/2)
	Pocket.RoughingClearance = MOPParameter
	
	CamBamUI.MainUI.InsertMOP(Pocket)
End Sub

'******************************************************

Sub DrawRectangle(LowerLeft As Point3F, RectWidth As double, RectHeight As double, LayerID As String, Overcut As double)
	' Overcut is to ensure the pocket operation leaves 'flat' cuts across the width of the stock
	' so it has to cut past the stock sides, currently by ( 0.6 * Tool Diameter )
	Dim PRect As Polyrectangle = new Polyrectangle()
	Dim LocalPoint As Point3F = LowerLeft
	Dim LayerMemory As Layer = ActiveLayer()
	Dim LayerMemoryName As string = LayerMemory.Name
	
	SetActiveLayer(LayerID)
	  
	LocalPoint.y = LocalPoint.y - Overcut
	
	PRect.LowerLeft = LocalPoint
	PRect.Width = RectWidth
	PRect.Height = RectHeight + (Overcut * 2)
	
	PRect.Add(LocalPoint)
	LocalPoint.y = LowerLeft.y + RectHeight + Overcut
	Prect.Add(LocalPoint)
	LocalPoint.x = LowerLeft.x + PRect.Width
	Prect.Add(LocalPoint)
	LocalPoint.y = LowerLeft.y - Overcut
	Prect.Add(LocalPoint)
	doc.Add(PRect)
		
	SetActiveLayer(LayerMemoryName)   ' good manners to reset layer to what it was upon entry
End Sub

'******************************************************

Sub WriteText(TopLeft As Point3F, LayerID As String, TextString As String)
	Dim	SomeText As MText = new MText()
	Dim LayerMemory As Layer = ActiveLayer()
	Dim LayerMemoryName As string = LayerMemory.Name
	
	SetActiveLayer(LayerID)
 
	SomeText.P1=TopLeft
	SomeText.Height = 5
	SomeText.Font = "Arial"
	SomeText.Text = TextString
	doc.Add(SomeText)
		
	SetActiveLayer(LayerMemoryName)' good manners to reset layer to what it was upon entry
End Sub
 
'******************************************************

Sub UpdateSomeValues2
	
	' get latest form values
	GetFormValues()
	GetMaxToolDia()

    'show either largest tool possible or user entered value, whichever is smallest
    If MaxToolDia < FJ_ToolDiameter AndAlso MaxToolDia > 0 then
		ToolDiameterBox.Text = MaxToolDia.ToString("G4")	
	    ToolDiameterBox.Refresh()
	End if
	
    ' if Pattern option selected run Presets()
	If radio2.checked Then
		Presets()
	end if 

	Animate() ' run the drawing routine
End Sub
	
'******************************************************

Sub GetMaxToolDia()	  
	' need to run appropriate maths routine to determine smallest size
	Select Case RadioButtonID
		Case 1 ' linear graduated fingers  
			RunMaths2()		
		Case 2 ' mask fingers 
			RunMaths3()		
	End Select
	MaxToolDia = GetSmallestValue()	- (2 * FJ_FitInt)'scan FJ_Points() array for smallest value
End Sub	

'******************************************************

Sub RunMaths2() ' for Graduated option
    ' graduated linear Pattern
	Dim Fingers As integer
	Dim n1 as double
	Dim n2 as double
	Dim n3 as double
	Dim n4 as double
	Dim n5 as double
	
	' Note: used a spreadsheet to derive and test maths
	n5 = FJ_NumFingers-1
	n1 = ((n5*(n5+1))/2)*(FJ_ScalingNum+1)
	n2 = n1/n5
	n3 = FJ_StockWidth / n2 
	n4 = (1/n5)*(FJ_ScalingNum-1)
		
	'fill the I/O array
	For Fingers = 1 to FJ_NumFingers
		FJ_Points(Fingers) = (1+((Fingers-1)*n4))*n3
	Next Fingers  
		
	'set first point to zero
	FJ_Points(0)=0
	If IsReverse.Checked then ReverseArray()	
End Sub		

'******************************************************

Sub RunMaths3() ' for Pattern option
	
	Dim Fingers As integer
	Dim Index2 as integer
	Dim Index
	Dim Pattern(10) as double
	Dim Total as double
	Dim Fractions as double
	Dim Mask(MaxArraySize)
	Dim MaskTotal as double
	
	'fill the Mask array from Mask NumericUpDown's
	Pattern(0) = Mask1Num
	Pattern(1) = Mask2Num
	Pattern(2) = Mask3Num
	Pattern(3) = Mask4Num
	Pattern(4) = Mask5Num
	Pattern(5) = Mask6Num
	Pattern(6) = Mask7Num
	Pattern(7) = Mask8Num
	Pattern(8) = Mask9Num
	Pattern(9) = Mask10Num
	 
	Index=1
	'fill mask array with values from Mask NumericUpDown's
	for Fingers = 1 to FJ_NumFingers step FJ_MaskNum
	    for Index2 = 0 to FJ_MaskNum-1
		     Mask(Index) = Pattern(Index2)
		   	 Index = Index+1
		next Index2
	next Fingers
	
	' Note: used a spreadsheet to derive and test maths
	' get True Total of mask values
	for Fingers = 1 to FJ_NumFingers
		MaskTotal = MaskTotal + Mask(Fingers)
	next Fingers  
		
	Total = (MaskTotal * FJ_ScalingNum)+(FJ_NumFingers - MaskTotal)
	Fractions = FJ_StockWidth / Total
	
	' populate I/O array	
	For Fingers = 1 to FJ_NumFingers 	
		FJ_Points(Fingers) = ((Mask(Fingers)*(FJ_ScalingNum-1))+1) * Fractions
	Next Fingers	
	
	'set first point to zero
	FJ_Points(0)=0
	If IsReverse.Checked then ReverseArray()
End Sub		

'********************************************************

Function GetSmallestValue() ' find smallest value in I/O array, equates to smallest finger width and part of max tool diameter

	Dim Index as integer
	Dim MinValue as double = 100 ' just a big enough starting figure
  
    For Index = 1 to MaxArraySize
		If FJ_Points(Index) <> 0 Then 
		    If FJ_Points(Index)< MinValue Then MinValue = FJ_Points(Index) 
		End If
	Next Index
	
	Return MinValue ' can't be zero
End Function

'******************************************************

Sub GetFormValues() ' get latest values from user input

    ' prevents GetSmallestValue() obtaining wrong values from a previous maths routine
	ClearOutArray()
	
	If IsNumeric(StockWidthBox.Text) then FJ_StockWidth = Math.Round(csng(StockWidthBox.Text), 4)
   	If IsNumeric(StockThicknessBox.Text) then FJ_StockThickness = Math.Round(csng(StockThicknessBox.Text), 4) 	
	If IsNumeric(FitIntBox.Text) then FJ_FitInt = Math.Round(csng(FitIntBox.Text), 4) 	
	If IsNumeric(ToolDiameterBox.Text) then FJ_ToolDiameter = Math.Round(csng(ToolDiameterBox.Text), 4) 	
	If IsNumeric(CleanUpBox.Text) then FJ_Cleanup = Math.Round(csng(CleanUpBox.Text), 4) 	
    FJ_ScalingNum = Scaling.Value 	
    FJ_MaskNum = MaskNum.Value
  	FJ_NumFingers = NumFingersBox.Value
	Mask1Num = Mask1.Value
	Mask2Num = Mask2.Value
	Mask3Num = Mask3.Value
	Mask4Num = Mask4.Value
	Mask5Num = Mask5.Value
	Mask6Num = Mask6.Value
	Mask7Num = Mask7.Value
	Mask8Num = Mask8.Value
	Mask9Num = Mask9.Value
	Mask10Num = Mask10.Value
End Sub

'******************************************************

Sub ClearOutArray() ' set contents to zero to remove traces of prior use
	Dim Index as integer
	' set all positions of I/O array to zero
	For index= 0 to MaxArraySize
		FJ_Points(index)=0
	Next index
End Sub	
	
'******************************************************

Function RadioButtonID() ' which radio button was selected
	Dim RTVal as integer = 99
    	 
    if radio1.Checked  then 
	   RTVal = 1
	else if radio2.Checked then
	   RTVal = 2
	end if
	Return RTVal
End Function	

'******************************************************

Sub ReverseArray()
	Dim Temp(MaxArraySize) as Double
	Dim Index as integer 
	
	' get a copy of array
	For Index = 1 to FJ_NumFingers
	     Temp(Index)=FJ_Points(Index)
	Next Index	 
	' write contents back in reverse order
	For Index = 1 to FJ_NumFingers
	  FJ_Points(Index) = Temp(FJ_NumFingers-(Index-1))
    Next Index
End Sub	  
	  
'******************************************************	  	  

Sub HideMaskControls(Toggle As Integer) ' hide controls if Pattern checkbox not selected
    Mask1.Visible = Toggle
	Mask2.Visible = Toggle
	MaskNum.Visible = Toggle
	PresetList.Visible = Toggle
	MaskNumLabel.Visible = Toggle
	PresetsLabel.Visible = Toggle
	
	' reset values in text boxes
	MaskNum.Value = 2	
	MaskNum.Refresh()
End Sub	  
	  
'******************************************************	  

Sub UpdateVisibility()
	Dim  Val as integer

	' do some bitwise ANDing of MaskNum NumericUpDown to toggle visibility
	Val = (2 ^ (MaskNum.Value-2))-1
	
    Mask3.Visible = 1 And Val
	Mask4.Visible = 2 And Val
	Mask5.Visible = 4 And Val
	Mask6.Visible = 8 AND Val
	Mask7.Visible = 16 And Val
	Mask8.Visible = 32 And Val
	Mask9.Visible = 64 And Val
	Mask10.Visible = 128 And Val
End Sub			
	
'******************************************************	 
 	
Sub PopulateTheForm()	
  ' declare picture boxes	
	Dim Pic1 As New System.Windows.Forms.PictureBox()
	Dim Pic2 As New System.Windows.Forms.PictureBox()
	Dim Pic3 As New System.Windows.Forms.PictureBox()
	Dim Pic4 As New System.Windows.Forms.PictureBox()
	Dim Pic5 As New System.Windows.Forms.PictureBox()
	Dim Pic6 As New System.Windows.Forms.PictureBox()
	Dim Pic7 As New System.Windows.Forms.PictureBox()
	Dim Pic8 As New System.Windows.Forms.PictureBox()
	Dim Pic9 As New System.Windows.Forms.PictureBox()
	Dim Pic10 As New System.Windows.Forms.PictureBox()
	Dim Pic11 As New System.Windows.Forms.PictureBox()
	Dim Pic12 As New System.Windows.Forms.PictureBox()
	
	' declare labels		
	Dim StockWidthLabel As new System.Windows.Forms.Label()	
	Dim StockThicknessLabel As new System.Windows.Forms.Label
	Dim NumFingersLabel As new System.Windows.Forms.Label()
	Dim FitIntLabel As new System.Windows.Forms.Label()
	Dim CleanUpLabel As new System.Windows.Forms.Label()
	Dim ToolDiameterLabel As new System.Windows.Forms.Label()
	Dim ScalingLabel As New System.Windows.Forms.Label()

	'to sort
	Dim S1 As New System.Windows.Forms.Label()
	Dim S2 As New System.Windows.Forms.Label()
    Dim AIndex as integer
	Dim c1 as integer = 0
	Dim c2 as integer = 0
	Dim c3 as integer = 0
	
' ************************ FORM1 ***************************
	' display centre screen
	Form1.Size = New System.Drawing.Size(545, 700)
    Form1.Text = "Vertical Woodworking Joints - Finger Joints v2.0"
	Form1.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
'
' *********************** BUTTONS **************************
	' buttons definitions
	OK_button.Text = "OK"
    OK_button.Location = New System.Drawing.Point(200,630)
    
	Cancel_button.Text = "Cancel"
	Cancel_button.Location = New system.Drawing.Point(300,630)
		
 '********************* CHECK BOXES *************************				
	' check box definitions
	IsReverse.Location = New System.Drawing.Point(120, 15)
	IsReverse.Text = "Reversed"
	
	SwapStock.Location = New System.Drawing.Point(120, 36)
	SwapStock.Text = "Swap Stock"
	
' ********************* RADIO BUTTONS ***********************
	radio1.Location = New System.Drawing.Point(10, 15)
	radio1.Text = "Graduated"
	radio1.Checked = True
	
	radio2.Location = New System.Drawing.Point(10, 36)
	radio2.Text = "Pattern"
	
	groupBox1.Location = New System.Drawing.Point(290, 466)
	groupBox1.Size = New System.Drawing.Size(230, 65)
	groupBox1.Text = " Pattern "

' ******************** NUMERIC UPDOWN ***********************		
	' numeric updown definitions
	Scaling.Location = New System.Drawing.Point(150, 490)
	Scaling.Size = New System.Drawing.Size(50, 80)
	Scaling.DecimalPlaces = 1
	Scaling.Value = 2.0
	Scaling.Maximum = 4.0
	Scaling.Minimum = 1.0
	Scaling.Increment = 0.1
	
	ScalingLabel.AutoSize = True
	ScalingLabel.Text = "Scaling"
	ScalingLabel.Location = New System.Drawing.Point(202,492)
	
	PresetsLabel.AutoSize = True
	PresetsLabel.Text = "Preset Patterns"
	PresetsLabel.Location = New System.Drawing.Point(146,560)
		
	MaskNum.Location = New System.Drawing.Point(20, 490)
	MaskNum.Size = New System.Drawing.Size(45, 40)
	MaskNum.Value = 2
	MaskNum.Maximum = 10
	MaskNum.Minimum = 2
	MaskNum.Increment = 1
		
	Mask1.Location = New System.Drawing.Point(20, 532)
	Mask1.Size = New System.Drawing.Size(45, 40)
	Mask1.DecimalPlaces = 1
	Mask1.Value = 0.0
	Mask1.Maximum = 1.0
	Mask1.Minimum = 0.0
	Mask1.Increment = 0.1
	
	Mask2.Location = New System.Drawing.Point(65, 532)
	Mask2.Size = New System.Drawing.Size(45, 40)
	Mask2.DecimalPlaces = 1
	Mask2.Value = 1.0
	Mask2.Maximum = 1.0
	Mask2.Minimum = 0.0
	Mask2.Increment = 0.1
	
	Mask3.Location = New System.Drawing.Point(110, 532)
	Mask3.Size = New System.Drawing.Size(45, 40)
	Mask3.DecimalPlaces = 1
	Mask3.Value = 1.0
	Mask3.Maximum = 1.0
	Mask3.Minimum = 0.0
	Mask3.Increment = 0.1
	Mask3.Visible = False
	
	Mask4.Location = New System.Drawing.Point(155, 532)
	Mask4.Size = New System.Drawing.Size(45, 40)
	Mask4.DecimalPlaces = 1
	Mask4.Value = 1.0
	Mask4.Maximum = 1.0
	Mask4.Minimum = 0.0
	Mask4.Increment = 0.1
	Mask4.Visible = False
	
	Mask5.Location = New System.Drawing.Point(200, 532)
	Mask5.Size = New System.Drawing.Size(45, 40)
	Mask5.DecimalPlaces = 1
	Mask5.Value = 1.0
	Mask5.Maximum = 1.0
	Mask5.Minimum = 0.0
	Mask5.Increment = 0.1
	Mask5.Visible = False

	Mask6.Location = New System.Drawing.Point(245, 532)
	Mask6.Size = New System.Drawing.Size(45, 40)
	Mask6.DecimalPlaces = 1
	Mask6.Value = 1.0
	Mask6.Maximum = 1.0
	Mask6.Minimum = 0.0
	Mask6.Increment = 0.1
	Mask6.Visible = False

	Mask7.Location = New System.Drawing.Point(290, 532)
	Mask7.Size = New System.Drawing.Size(45, 40)
	Mask7.DecimalPlaces = 1
	Mask7.Value = 1.0
	Mask7.Maximum = 1.0
	Mask7.Minimum = 0.0
	Mask7.Increment = 0.1
	Mask7.Visible = False

	Mask8.Location = New System.Drawing.Point(335, 532)
	Mask8.Size = New System.Drawing.Size(45, 40)
	Mask8.DecimalPlaces = 1
	Mask8.Value = 1.0
	Mask8.Maximum = 1.0
	Mask8.Minimum = 0.0
	Mask8.Increment = 0.1
	Mask8.Visible = False

	Mask9.Location = New System.Drawing.Point(380, 532)
	Mask9.Size = New System.Drawing.Size(45, 40)
	Mask9.DecimalPlaces = 1
	Mask9.Value = 1.0
	Mask9.Maximum = 1.0
	Mask9.Minimum = 0.0
	Mask9.Increment = 0.1
	Mask9.Visible = False

	Mask10.Location = New System.Drawing.Point(425, 532)
	Mask10.Size = New System.Drawing.Size(45, 40)
	Mask10.DecimalPlaces = 1
	Mask10.Value = 1.0
	Mask10.Maximum = 1.0
	Mask10.Minimum = 0.0
	Mask10.Increment = 0.1
	Mask10.Visible = False
	
 ' ************************ PICTURES ************************		
   	' picture definitions		
	Pic1.Location = New System.Drawing.Point(10, 10)
	Pic1.Size = New System.Drawing.Size(150, 75)
	Pic1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
	Pic1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
	Pic1.Image = Image.FromFile(path1 & "scripts\Finger_Joint_Images\width.jpg")
	
	Pic2.Location = New System.Drawing.Point(190, 10)
	Pic2.Size = New System.Drawing.Size(150, 75)
	Pic2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
	Pic2.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
	Pic2.Image = Image.FromFile(path1 & "scripts\Finger_Joint_Images\thick.jpg")
	
	Pic3.Location = New System.Drawing.Point(371, 10)
	Pic3.Size = New System.Drawing.Size(150, 75)
	Pic3.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
	Pic3.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
	Pic3.Image = Image.FromFile(path1 & "scripts\Finger_Joint_Images\fingers.jpg")
	
	Pic4.Location = New System.Drawing.Point(10, 125)
	Pic4.Size = New System.Drawing.Size(150, 75)
	Pic4.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
	Pic4.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
	Pic4.Image = Image.FromFile(path1 & "scripts\Finger_Joint_Images\fit.jpg")

	Pic5.Location = New System.Drawing.Point(190, 125)
	Pic5.Size = New System.Drawing.Size(150, 75)
	Pic5.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
	Pic5.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
	Pic5.Image = Image.FromFile(path1 & "scripts\Finger_Joint_Images\cleanup.jpg")
		
	Pic6.Location = New System.Drawing.Point(371, 125)
	Pic6.Size = New System.Drawing.Size(150, 75)
	Pic6.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
	Pic6.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
	Pic6.Image = Image.FromFile(path1 & "scripts\Finger_Joint_Images\tool.jpg")
	
' ************************* LABELS **************************
    ' Label definitions 	
	StockWidthLabel.AutoSize = True
	StockWidthLabel.Text = "Stock WIDTH"
	StockWidthLabel.Location = New System.Drawing.Point(65,94)
		
	StockThicknessLabel.AutoSize = True
	StockThicknessLabel.Text = "Stock THICKNESS"
	StockThicknessLabel.Location = New System.Drawing.Point(245, 94)
		
	NumFingersLabel.AutoSize = True
	NumFingersLabel.Text = "Number of FINGERS"
	NumFingersLabel.Location = New System.Drawing.Point(425, 94)
		
	FitIntLabel.AutoSize = True
	FitIntLabel.Text = "Fit INTERFERENCE"
	FitIntLabel.Location = New System.Drawing.Point(65, 210)
		
	CleanUpLabel.AutoSize = True
	CleanUpLabel.Text = "Cleanup ALLOWANCE"
	CleanUpLabel.Location = New System.Drawing.Point(245, 210)
		
	ToolDiameterLabel.AutoSize = True
	ToolDiameterLabel.Text = "Tool DIAMETER"
	ToolDiameterLabel.Location = New System.Drawing.Point(425, 210)
	Form1.Controls.Add(StockWidthLabel)
    
	MaskNumLabel.AutoSize = True
	MaskNumLabel.Text = "Pattern Width"
	MaskNumLabel.Location = New System.Drawing.Point(69, 492)
		
' *********************** TEXT BOXES ************************
    ' text box definitions 	
	StockWidthBox	.Location = New System.Drawing.Point(10, 90)
	StockWidthBox	.Name = "StockWidthBox"
	StockWidthBox	.Text = "100"
	StockWidthBox	.Size = New System.Drawing.Size(50, 20)
	StockWidthBox	.TabIndex = 1
	StockWidthBox	.TabStop = True 
		
	StockThicknessBox	.Location = New System.Drawing.Point(190, 90)
	StockThicknessBox	.Name = "StockThicknessBox"
	StockThicknessBox	.Text = "19"
	StockThicknessBox	.Size = New System.Drawing.Size(50, 20)
	StockThicknessBox	.TabIndex = 1
	StockThicknessBox	.TabStop = True
		
	NumFingersBox.Location = New System.Drawing.Point(370, 90)
	NumFingersBox.Size = New System.Drawing.Size(45, 40)
	NumFingersBox.Value = 20
	NumFingersBox.Maximum = 100
	NumFingersBox.Minimum = 2
	NumFingersBox.Increment = 1
	NumFingersBox.Visible = True	
				
	FitIntBox	.Location = New System.Drawing.Point(10, 206)
	FitIntBox	.Name = "FitIntBox"
	FitIntBox	.Text = "0.1"
	FitIntBox	.Size = New System.Drawing.Size(50, 20)
	FitIntBox	.TabIndex = 1
	FitIntBox	.TabStop = True
		
	CleanUpBox	.Location = New System.Drawing.Point(190, 206)
	CleanUpBox	.Name = "CleanUpBox"
	CleanUpBox	.Text = "0.1"
	CleanUpBox	.Size = New System.Drawing.Size(50, 20)
	CleanUpBox	.TabIndex = 1
	CleanUpBox	.TabStop = True
	   	
	ToolDiameterBox	.Location = New System.Drawing.Point(370, 206)
	ToolDiameterBox	.Name = "ToolDiameterBox"
	ToolDiameterBox	.Text = "4"
	ToolDiameterBox	.Size = New System.Drawing.Size(50, 20)
	ToolDiameterBox	.TabIndex = 1
	ToolDiameterBox	.TabStop = True

	' picturebox for animation
	Anim1.Location = New System.Drawing.Point(10, 250)
	Anim1.Size = New System.Drawing.Size(512, 200)
	Anim1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage
	Anim1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
       	
	F1.Width = 10
 	F1.Height = 50
	F1.Location = New System.Drawing.Point(25,100)
	F1.BackColor =  Color.FromArgb(c1, c2, c3)
    
	F2.Width = 10
 	F2.Height = 50
	F2.Location = New System.Drawing.Point(65,100)
	F2.BackColor = Color.FromArgb(c1, c2, c3)
    
	F3.Width = 10
 	F3.Height = 50
	F3.Location = New System.Drawing.Point(105,100)
	F3.BackColor = Color.FromArgb(c1,c2,c3)
    
	F4.Width = 10
 	F4.Height = 50
	F4.Location = New System.Drawing.Point(165,100)
	F4.BackColor = Color.FromArgb(c1,c2,c3)
	
	F5.Width = 10
 	F5.Height = 50
	F5.Location = New System.Drawing.Point(25,100)
	F5.BackColor = Color.FromArgb(c1,c2,c3)
    
	F6.Width = 10
 	F6.Height = 50
	F6.Location = New System.Drawing.Point(65,100)
	F6.BackColor = Color.FromArgb(c1,c2,c3)
    
	F7.Width = 10
 	F7.Height = 50
	F7.Location = New System.Drawing.Point(105,100)
	F7.BackColor = Color.FromArgb(c1,c2,c3)
    
	F8.Width = 10
 	F8.Height = 50
	F8.Location = New System.Drawing.Point(165,100)
	F8.BackColor = Color.FromArgb(c1,c2,c3)
    
	F9.Width = 10
 	F9.Height = 50
	F9.Location = New System.Drawing.Point(65,100)
	F9.BackColor = Color.FromArgb(c1,c2,c3)
    
	F10.Width = 10
 	F10.Height = 50
	F10.Location = New System.Drawing.Point(105,100)
	F10.BackColor = Color.FromArgb(c1,c2,c3)
    
	F11.Width = 10
 	F11.Height = 50
	F11.Location = New System.Drawing.Point(165,100)
	F11.BackColor = Color.FromArgb(c1,c2,c3)
	
	F12.Width = 10
 	F12.Height = 50
	F12.Location = New System.Drawing.Point(25,100)
	F12.BackColor = Color.FromArgb(c1,c2,c3)
    
	F13.Width = 10
 	F13.Height = 50
	F13.Location = New System.Drawing.Point(65,100)
	F13.BackColor = Color.FromArgb(c1,c2,c3)
    
	F14.Width = 10
 	F14.Height = 50
	F14.Location = New System.Drawing.Point(105,100)
	F14.BackColor = Color.FromArgb(c1,c2,c3)
    
	F15.Width = 10
 	F15.Height = 50
	F15.Location = New System.Drawing.Point(165,100)
	F15.BackColor = Color.FromArgb(c1,c2,c3)
    ' stock item
	S1.Width = 492
	S1.Height = 40
	'S1.Text = "Stock Item 1"
	S1.Location = New System.Drawing.Point(20,150)
	S1.BackColor = Color.FromArgb(c1,c2,c3)
	
	S2.Width = 492
	S2.Height = 40
	'S1.Text = "Stock Item 2"
	S2.Location = New System.Drawing.Point(20,10)
	S2.BackColor = Color.FromArgb(c1,c2,c3)
		 
	' presets combobox
	PresetList.Left = 20
	PresetList.Top = 558
	PresetList.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
	PresetList.Items.Add("Flatliner")
  	PresetList.Items.Add("Bed 'O Nails")
	PresetList.Items.Add("Gothic")
	PresetList.Items.Add("Saw Tooth")
	PresetList.Items.Add("Antenna")
	PresetList.Items.Add("Nursery Slope")
	PresetList.Items.Add("Off Piste")
  	PresetList.Items.Add("Half Pipe")
	PresetList.Items.Add("Mt.Vesuvius")
	PresetList.Items.Add("Sine Wave")
	
	' animation
	Form1.Controls.Add(Anim1)	
	Form1.Controls.Add(PresetList) 
	Anim1.Controls.Add(S1)
	Anim1.Controls.Add(S2)
	Anim1.Controls.Add(F1)
	Anim1.Controls.Add(F2)
	Anim1.Controls.Add(F3)
	Anim1.Controls.Add(F4)
	Anim1.Controls.Add(F5)
	Anim1.Controls.Add(F6)
	Anim1.Controls.Add(F7)
	Anim1.Controls.Add(F8)
	Anim1.Controls.Add(F9)
	Anim1.Controls.Add(F10)
	Anim1.Controls.Add(F11)
	Anim1.Controls.Add(F12)
	Anim1.Controls.Add(F13)
	Anim1.Controls.Add(F14)
	Anim1.Controls.Add(F15)

' Add buttons to Form1
    Form1.Controls.Add(OK_button)
    Form1.Controls.Add(Cancel_button)

' Add controls to groupbox and form1
    groupBox1.Controls.Add(radio1) 
    groupBox1.Controls.Add(radio2)
	Form1.Controls.Add(groupBox1)
	groupBox1.Controls.Add(IsReverse)
    groupBox1.Controls.Add(SwapStock)

' Add numericUpDowns to Form1
	Form1.Controls.Add(Scaling)	
	
	Form1.Controls.Add(MaskNum)	
	Form1.Controls.Add(Mask1)	
	Form1.Controls.Add(Mask2)	
	Form1.Controls.Add(Mask3)	
	Form1.Controls.Add(Mask4)	
	Form1.Controls.Add(Mask5)	
	Form1.Controls.Add(Mask6)	
	Form1.Controls.Add(Mask7)	
	Form1.Controls.Add(Mask8)	
	Form1.Controls.Add(Mask9)	
	Form1.Controls.Add(Mask10)	

' Add Labels to Form1	
	Form1.Controls.Add(ScalingLabel)	
	Form1.Controls.Add(PresetsLabel)	
	Form1.Controls.Add(StockThicknessLabel)
	Form1.Controls.Add(NumFingersLabel)
	Form1.Controls.Add(FitIntLabel)
	Form1.Controls.Add(CleanUpLabel)
	Form1.Controls.Add(ToolDiameterLabel)
    Form1.Controls.Add(MaskNum)
	Form1.Controls.Add(MaskNumLabel)
	
' Add pictures to Form1
	Form1.Controls.Add(Pic1)
	Form1.Controls.Add(Pic2)
	Form1.Controls.Add(Pic3)
	Form1.Controls.Add(Pic4)		
	Form1.Controls.Add(Pic5)	
	Form1.Controls.Add(Pic6)	

' Add text boxes to Form1
	Form1.Controls.Add(StockWidthBox)
	Form1.Controls.Add(StockThicknessBox)
	Form1.Controls.Add(NumFingersBox)
	Form1.Controls.Add(FitIntBox)
	Form1.Controls.Add(CleanUpBox)
    Form1.Controls.Add(ToolDiameterBox)
	
End Sub	

'******************************************************	 

Sub Animate()
	Dim Index as integer
	dim realwidth as double
	dim animratio  as integer
	dim lableft as double  
	dim MaxFingers as integer = 15
    dim PosY as integer
	dim Stock1 as integer = 50
	dim Stock2 as integer = 103
	dim temp1 as integer
	
	if SwapStock.Checked then
       temp1 = Stock1 
	   Stock1 = Stock2
       Stock2 = temp1
    end if	   
		
	' adjust for less than 15 fingers
	if FJ_NumFingers < 15 Then MaxFingers = FJ_NumFingers
	 
	' get actual width of fingers from real data
	for Index = 0 to MaxFingers
		realwidth = realwidth + FJ_Points(Index)
	next Index	 
	
	' just a ratio for graphics display - could be better !
	animratio =  452/ realwidth
    lableft = (FJ_Points(0) * animratio ) + 20 ' just to get things started
	
	for index = 0 to 14
        if index And 1 then ' alternate between stockitem1 and stockitem2
			 PosY = Stock1
		else PosY = Stock2
        End if		
		AnimLabels(index).Location = New System.Drawing.Point(lableft,PosY) ' set bottomleft location
		AnimLabels(index).Width = FJ_Points(index+1) * animratio ' set width
		lableft = lableft + FJ_Points(index+1) * animratio ' update distance from left 0
	next index

	 Anim1.Refresh()
End Sub

'******************************************************	 

Sub Presets()
    ' Format is, { pattern-width,scaling,mask1,mask2,mask3,mask4,mask5,mask6,mask7,mask8,mask9,mask10 }
		
	Dim P1() As double = {2,1.0,1,0,0,0,0,0,0,0,0,0 } ' Flatliner
	Dim P2() As double = {3,2.0,1,0,1,0,0,0,0,0,0,0 } ' Bed of Nails
	Dim P3() As double = {7,3.5,0,0.5,0.8,1,0.8,0.5,0,0,0,0 } ' Gothic
	Dim P4() As double = {3,3,1,0.5,0,0,0,0,0,0,0,0} ' Saw Tooth
	Dim P5() As double = {10,4,1,0,0,0,1,1,0,0,0,1} ' Antenna
	Dim P6() As double = {10,1.5,1,0.9,0.8,0.7,0.6,0.5,0.4,0.3,0.2,0.1 } ' Nursery Slope
	Dim P7() As double = {10,4,1,0.9,0.8,0.7,0.6,0.5,0.4,0.3,0.2,0.1 } ' Off Piste
	Dim P8() As double = {10,2,1,0.6,0.3,0.1,0,0,0.1,0.3,0.6,1 } ' Half Pipe
	Dim P9() As double = {10,2.5,0,0.1,0.3,0.6,1,1,0.6,0.3,0.1,0 } ' Vesuvius
	Dim P10() As double = {10,4,0,0.6,0.9,1,0.8,0.2,0,0.1,0.4,1 } ' Sine Wave
	
	Dim MyShapes()() as double = { P1,P2,P3,P4,P5,P6,P7,P8,P9,P10 }
	Dim Index as integer
    
    ' Combo1 is event toggle 
	if Combo1 = 1 then
		If PresetList.SelectedIndex > -1 then ' don't do it if not a valid index
			for Index = 0 to 11
				PreS(Index) = MyShapes(PresetList.SelectedIndex)(Index) ' populate PreS() with preset
			next Index   		
			UpdateMaskBoxes() ' refresh the number boxes
		end if
		Combo1 = 0
	end if
End Sub

'******************************************************

Sub UpdateMaskBoxes() ' just update the mask value boxes
	dim Index as integer
	
	for Index = 0 to 11
		MaskArray(Index).Value = PreS(Index)
	    MaskArray(Index).Refresh()
	Next Index	
End Sub 
     
'******************************************************	 

	
	
	